#!/bin/bash

echo "🔧 Iniciando instalação do Botão Controlador..."

# Verifica se o script está no diretório correto
if [ ! -f botao_controlador.py ] || [ ! -f botao_controlador.service ]; then
  echo "❌ Arquivos botao_controlador.py ou botao_controlador.service não encontrados no diretório atual."
  exit 1
fi

# Copia os arquivos
echo "📦 Copiando arquivos para /home/pi e /etc/systemd/system/..."
sudo cp botao_controlador.py /home/pi/
sudo cp botao_controlador.service /etc/systemd/system/

# Dá permissão de execução no script Python
echo "🔧 Aplicando permissões de execução..."
sudo chmod +x /home/pi/botao_controlador.py

# Ativa e inicia o serviço
echo "🔄 Atualizando systemd e iniciando serviço..."
sudo systemctl daemon-reload
sudo systemctl enable botao_controlador.service
sudo systemctl restart botao_controlador.service

# Status final
echo "✅ Instalação concluída!"
echo "💡 Veja o status com: sudo systemctl status botao_controlador.service"
