#!/usr/bin/env python3

import requests
from gpiozero import Device, Button
from gpiozero.pins.lgpio import LGPIOFactory
import time

Device.pin_factory = LGPIOFactory()

INSTANCIAS = {
    "valentina": {
        "url": "http://localhost:5000",
        "apikey": "CmB07EkD6we7RUMF8bZqnVIoFvJRKvtOLMvr4n7Ny18"
    },
    "josefina": {
        "url": "http://localhost:5001",
        "apikey": "CmB07EkD6we7RUMF8bZqnVIoFvJRKvtOLMvr4n7Ny18"
    }
}

BOTOES = {
    6:  ("valentina", [{"type": "action", "execute": "connect"}, {"type": "gcode", "execute": "M300 S440 P500"}]),
    13: ("valentina", [{"type": "gcode", "execute": "M104 S200"}, {"type": "gcode", "execute": "M300 S440 P500"}]),
    16: ("valentina", [{"type": "gcode", "execute": "M140 S60"}, {"type": "gcode", "execute": "M300 S440 P500"}]),
    21: ("valentina", [{"type": "action", "execute": "resume"}, {"type": "gcode", "execute": "M300 S440 P500"}]),

    24: ("josefina", [{"type": "action", "execute": "connect"}, {"type": "gcode", "execute": "M300 S440 P500"}]),
    5:  ("josefina", [{"type": "gcode", "execute": "M104 S200\nM140 S60"}, {"type": "gcode", "execute": "M300 S440 P500"}]),
    25: ("josefina", [{"type": "gcode", "execute": "M140 S60"}, {"type": "gcode", "execute": "M300 S440 P500"}]),
    26: ("josefina", [{"type": "action", "execute": "resume"}, {"type": "gcode", "execute": "M300 S440 P500"}])
}

def enviar_atividades(instancia, atividades):
    dados = INSTANCIAS[instancia]
    headers = {"X-Api-Key": dados["apikey"]}

    for atividade in atividades:
        if atividade["type"] == "action":
            if atividade["execute"] == "connect":
                r = requests.post(f"{dados['url']}/api/connection", headers=headers, json={"command": "connect"})
            elif atividade["execute"] == "resume":
                r = requests.post(f"{dados['url']}/api/job", headers=headers, json={"command": "pause", "action": "resume"})
            else:
                print(f"Ação desconhecida: {atividade['execute']}")
                continue
        elif atividade["type"] == "gcode":
            comandos = atividade["execute"].split("\n")
            r = requests.post(f"{dados['url']}/api/printer/command", headers=headers, json={"commands": comandos})
        else:
            print(f"Tipo desconhecido: {atividade['type']}")
            continue

        if r.ok:
            print(f"[{instancia}] {atividade['execute']} OK")
        else:
            print(f"[{instancia}] Erro {r.status_code}: {r.text}")

botoes = []
for gpio, (instancia, atividades) in BOTOES.items():
    botao = Button(gpio, pull_up=True, bounce_time=0.05)
    botao.when_pressed = lambda i=instancia, a=atividades: enviar_atividades(i, a)
    botoes.append(botao)

print("Monitorando botões... Ctrl+C para sair.")

try:
    while True:
        time.sleep(1)
except KeyboardInterrupt:
    print("\nSaindo...")

for botao in botoes:
    botao.close()
